module Buffer = 

  (* *private* details *)
  type t =
    {
      mutable buffer : string;
      mutable datalength : int; (* the length of the data *)
    }

  (* builds a new buffer *)
  let build n = { buffer = String.build n; datalength = 0; }

  (* get the data in a buffer *)
  let contents b = String.sub b.buffer 0 b.datalength
  
  (* length of the data in a buffer *)
  let length b = b.datalength

  (* removes all data in a buffer *)
  let clear b = b.datalength <- 0

  (* grows the buffer size by 2 
     *private* *)
  let grow b new_size = 
    let new_buffer = String.build new_size in
    let () = String.blit b.buffer 0 new_buffer 0 b.datalength in 
    b.buffer <- new_buffer
    
  let add_substring b s startpos len =
    let new_size = b.datalength + len in
    let () = if new_size > String.length b.buffer then grow b (new_size * 2) else () in 
    let () = String.blit s startpos b.buffer b.datalength len in 
    b.datalength <- new_size

  let add_string b s =
    add_substring b s 0 (String.length s)
    
  let add_char b c =
    let new_size = b.datalength + 1 in
    let () = if new_size > String.length b.buffer then grow b (new_size * 2) else () in 
    let () = String.set b.buffer b.datalength c in 
    b.datalength <- new_size
    
    
  
endmodule
